class CapacityDisplay
  attr_accessor :value
  def initialize(args, name, icon_path, initial_value)
    @args = args
    @value = initial_value

    @icon_path = icon_path
    @font = args.state.text_font
    @rt_name = name.to_sym
    @w = 100
    @h = 25
  end

  def tick(args)
    @args = args
  end

  def draw(args)
    args.outputs[@rt_name].w = @w
    args.outputs[@rt_name].h = @h
    args.outputs[@rt_name].transient!
  
    text_display = "%03d" % "#{@value}"

    output = output(args)
    args.outputs[@rt_name].primitives << output

    return {w: @w, h: @h, path: @rt_name, primitive_marker: :sprite}
  end

  def output(args)
    text_display = "%03d" % "#{@value}"

    output = [
      {x: 0, y: 0, w: 24, h: 24, path: @icon_path, primitive_marker: :sprite},
      {x: 25, y: 12, text: "x", font: @font, size_px: 10, primitive_marker: :label}.merge(Color::WHITE),
      {x: 36, y: 18, text: text_display, font: @font, size_px: 16, primitive_marker: :label}.merge(Color::WHITE)
    ]
  end
end